#ifndef _FRIENDSLIST_SONY_H
#define _FRIENDSLIST_SONY_H

#include "UnityNP.h"
#include "Mutex.h"
//#include "FriendsList.h"
#include <np_toolkit.h>
#include <vector>
#include <string>
//#include <vector>

namespace UnityPlugin
{
	// Friend structure for returning to scripts.
	struct Friend
	{
		const unsigned char* npID;			// NpID, contains data corresponding to the SceNpID structure, can be used as id to send to when messaging.
		int npIDSize;						// Size of the npID byte array.
		const char* npOnlineID;				// NpID, just the string part of the ID, 16 bytes plus terminator.
		int npOnlineStatus;					// Online status.
		const char* npPresenceTitle;		// 128 bytes.
		int npPresenceSdkVersion;			// Seems to always be 0.
		int npPresenceType;					// InGame presence type
		const char* npPresenceStatus;		// Game play status, 192 characters.
		const char* npComment;				// Comment, 64 characters - PS3 only
		const unsigned char* npPresenceData;// Freely defined data, 128 bytes.
		int npPresenceDataSize;
	};

	PRX_EXPORT bool PrxFriendsListIsBusy();
	PRX_EXPORT bool PrxFriendsGetLastError(ResultCode* result);
	PRX_EXPORT ErrorCode PrxRefreshFriendsList();
	PRX_EXPORT void PrxLockFriendsList();
	PRX_EXPORT void PrxUnlockFriendsList();
	PRX_EXPORT int PrxGetFriendCount();
	PRX_EXPORT ErrorCode PrxGetFriend(int index, Friend* frnd);

	class CachedFriendsList
	{
	protected:
		SimpleLock m_Lock;
		bool m_Busy;

		struct CachedFriend
		{
			CachedFriend() : presenceData(NULL), npIdData(NULL) {}
			~CachedFriend()
			{
				free(presenceData);
				free(npIdData);
				free(status);
				free(comment);
			}
			std::string onlineID;
			std::string presenceTitle;
			std::string presenceStatus;
			SceNpId NpId;
			SceNpBasicPresenceDetails2	presence;
			unsigned int	state;
			unsigned char*  status;
			unsigned char*  comment;
			unsigned char* presenceData;
			unsigned char* npIdData;
		};

		std::vector<CachedFriend*> m_Friends;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::FriendsList> m_FutureFriendList;

		ResultCode m_LastResult;

		void ClearList(void);

	public:
		CachedFriendsList();
		~CachedFriendsList() {};
		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		void Lock();
		void Unlock();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);
		ErrorCode Refresh();
		int GetFriendCount() const;
		ErrorCode GetFriend(unsigned int index, Friend* frnd);
	};

	extern CachedFriendsList gFriendsList;
}

#endif // _FRIENDSLIST_SONY_H
